/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskContentEvent;
import filenet.vw.apps.taskman.VWTaskContentListener;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.message.VWConsoleEvent;
import filenet.vw.apps.taskman.message.VWConsoleListener;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class VWTaskMenuBar
extends JMenuBar
implements ActionListener,
VWTaskContentListener,
VWConsoleListener {
    private VWTaskCore m_taskCore = null;
    public JMenu m_fileMenu = null;
    public JMenuItem m_exitItem = null;
    public JMenu m_actionMenu = null;
    public JMenu m_consoleMenu = null;
    public JCheckBoxMenuItem m_consoleMsgPaneItem = null;
    public JMenuItem m_optionsItem = null;
    public JMenuItem m_clearItem = null;
    public JMenu m_helpMenu = null;
    public JMenuItem m_helpTopicsItem = null;
    public JMenuItem m_aboutItem = null;

    public VWTaskMenuBar(Container parent, boolean msgPanelVisible, VWTaskCore taskCore) {
        this.m_taskCore = taskCore;
        this.initMenuBar(parent, msgPanelVisible);
    }

    public void actionPerformed(ActionEvent ae) {
        String actionCMD = ae.getActionCommand();
        Object eventSource = ae.getSource();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.EXIT) == 0) {
                VWTaskCore.getInstance().performExitItemAction(true);
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.VIEW_MSG_PANE) == 0) {
                VWTaskCore.getInstance().viewConsoleMessagePane();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.OPTIONS) == 0) {
                VWTaskCore.getInstance().getConsoleMsgPanel().showOptionsDialog();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.CLEAR) == 0) {
                VWTaskCore.getInstance().getConsoleMsgPanel().clear();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP_TOPICS) == 0) {
                VWTaskCore.getInstance().displayHelp();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.ABOUT) == 0) {
                VWTaskCore.getInstance().displayAbout();
            } else {
                VWTaskCore.getInstance().actionPerformed(ae);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void taskContentChanged(VWTaskContentEvent evt) {
        VWTaskBaseNode node = evt.getBaseNode();
        String[] actions = node.getActions();
        JMenuItem actionItem = null;
        this.m_actionMenu.removeAll();
        if (actions != null) {
            for (int i = 0; i < actions.length; ++i) {
                if (VWStringUtils.compare(actions[i], "Add Separator") == 0) {
                    this.m_actionMenu.addSeparator();
                    continue;
                }
                actionItem = VWStringUtils.getMenuItemUsingString(actions[i]);
                actionItem.setActionCommand(actions[i]);
                actionItem.setEnabled(node.isActionEnabled(actions[i]));
                actionItem.addActionListener(this);
                this.m_actionMenu.add(actionItem);
            }
        }
        if (this.m_actionMenu != null) {
            this.m_actionMenu.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        }
    }

    public void consoleVisibilityChanged(VWConsoleEvent evt) {
        this.m_consoleMsgPaneItem.setState(evt.isVisible());
    }

    public void consoleLevelChanged(VWConsoleEvent evt) {
    }

    private void initMenuBar(Container parent, boolean msgPanelVisible) {
        try {
            this.m_fileMenu = VWStringUtils.getMenuUsingString(VWResource.File_withHK);
            this.add(this.m_fileMenu);
            this.m_exitItem = VWStringUtils.getMenuItemUsingString(VWResource.Exit_withHK);
            this.m_exitItem.setActionCommand(VWTaskActionCommand.EXIT);
            this.m_exitItem.addActionListener(this);
            this.m_fileMenu.add(this.m_exitItem);
            this.m_actionMenu = VWStringUtils.getMenuUsingString(VWResource.Action_withHK);
            this.add(this.m_actionMenu);
            this.m_consoleMenu = VWStringUtils.getMenuUsingString(VWResource.Console_withHK);
            this.add(this.m_consoleMenu);
            this.m_consoleMsgPaneItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWResource.ViewMessages_withHK);
            this.m_consoleMsgPaneItem.setActionCommand(VWTaskActionCommand.VIEW_MSG_PANE);
            this.m_consoleMsgPaneItem.setState(msgPanelVisible);
            this.m_consoleMsgPaneItem.addActionListener(this);
            this.m_consoleMenu.add(this.m_consoleMsgPaneItem);
            this.m_consoleMenu.addSeparator();
            this.m_optionsItem = VWStringUtils.getMenuItemUsingString(VWResource.Options_dots_withHK);
            this.m_optionsItem.setActionCommand(VWTaskActionCommand.OPTIONS);
            this.m_optionsItem.addActionListener(this);
            this.m_consoleMenu.add(this.m_optionsItem);
            this.m_clearItem = VWStringUtils.getMenuItemUsingString(VWResource.Clear_withHK);
            this.m_clearItem.setActionCommand(VWTaskActionCommand.CLEAR);
            this.m_clearItem.addActionListener(this);
            this.m_consoleMenu.add(this.m_clearItem);
            JMenu settingsMenu = this.m_taskCore.getSettingsMenu(this);
            if (settingsMenu != null) {
                this.add(settingsMenu);
            }
            this.m_helpMenu = VWStringUtils.getMenuUsingString(VWResource.Help_withHK);
            this.add(this.m_helpMenu);
            this.m_helpTopicsItem = VWStringUtils.getMenuItemUsingString(VWResource.HelpTopics_withHK);
            this.m_helpTopicsItem.setActionCommand(VWTaskActionCommand.HELP_TOPICS);
            this.m_helpTopicsItem.addActionListener(this);
            this.m_helpMenu.add(this.m_helpTopicsItem);
            this.m_aboutItem = VWStringUtils.getMenuItemUsingString(VWResource.About_withHK);
            this.m_aboutItem.setActionCommand(VWTaskActionCommand.ABOUT);
            this.m_aboutItem.addActionListener(this);
            this.m_helpMenu.add(this.m_aboutItem);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

